function table=latexTable41(SMs,words)

%
% table=latexTable41(SMs,words)
%
% Generate Table 4-1 in LaTex format
%
% Dongrui WU (dongruiw@usc.edu), 7/9/2008

N=length(words);
M=4*N+25;
for i=1:N
    if i<10
        table(i,1:23)=[num2str(i) '.  ' words(i,:)];
    else
        table(i,1:23)=[num2str(i) '. ' words(i,:)];
    end
end
for i=1:N
    for j=24:M
        table(i,j)=' ';
    end

    for k=1:N
        temp=round(100*SMs(i,k));
        if temp<10 & temp>0
            entry=['&.0' num2str(temp)];
        elseif temp==0
            entry=['&0  '];
        elseif temp==100
            entry=['&1  '];
        else
            entry=['&.' num2str(temp)];
        end
        table(i,(20+4*k):(23+4*k))=entry;
    end
    table(i,M-1:M)='\\';
end